//
//  libdss.h
//  libdssWrapper
//
//  Created by Сергей Дмитриев on 02/07/2019.
//  Copyright © 2019 SafeTech Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "dss_mobile_functions.h"
#import "DSSHandle.h"
#import "DSSKeysBlobs.h"

@interface libdss : NSObject

+(long)importTransportKey;

+(NSData * _Nullable)getPublicKeyInfo:(long)handle;

+(NSData * _Nullable)genNonce;

+(void)addEntropy:(NSData * _Nonnull)seed;

+(DSSKeysBlobs * _Nullable)decryptEncryptedBlob:(NSData * _Nonnull)blob
                                   transportKey:(long             )transportKey
                                      publicKey:(NSData * _Nonnull)publicKey;

+(DSSHandle * _Nullable)importEncryptedKey:(NSData   * _Nonnull)key
                                       kid:(NSString * _Nonnull)kid
                                  password:(NSString * _Nonnull)password;

+(NSData * _Nullable)exportKey:(DSSHandle * _Nonnull)handle
                           kid:(NSString  * _Nonnull)kid
                      password:(NSString  * _Nonnull)password;

+(NSData * _Nullable)generateHMAC:(DSSHandle   * _Nonnull)handle
                             data:(NSData      * _Nonnull)data
                           length:(int                   )hmacLength;

+(NSData * _Nullable)generateHMAC:(DSSHandle    * _Nonnull)handle
                             data:(NSData       * _Nonnull)data;

+(void)freeHandle:(DSSHandle * _Nonnull)handle;

@end
